/************************************************************************
 *
 * \file: GadgetLoader.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Baidu Carlife - Demo application
 *
 * \author: Ajay Kumar Sahoo / ajaykumar.sahoo@in.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef BDCL_GADGETLOADER_H
#define BDCL_GADGETLOADER_H

#include <string>
#include <iap2_init.h>
#include <iap2_usb_role_switch.h>
#include <iap2_initialize_usb_gadget.h>


namespace adit { namespace bdcl {

/* **********************  defines   ********************** */

#define APPLE_VENDOR_ID        0x05ac
#define APPLE_PRODUCT_ID_MIN   0x1200
#define APPLE_PRODUCT_ID_MAX   0x12FF

#define CONFIGFS_MOUNT_LOCATION                 "/sys/kernel/config"

/* Kernel 3.14 necessary kernel modules to load libcomposite and g_ffs */
#define CONFIGFS_MODULE_NAME                    "configfs"
#define USB_F_FS_MODULE_NAME                    "usb_f_fs"
#define U_ETHER_MODULE_NAME                     "u_ether"


#define LIBCOMPOSITE_MODULE_NAME                "libcomposite"
#define LINUX_USB_GADGET_MODULE_PATH            "/lib/modules/%s/kernel/drivers/usb/gadget/%s.ko"

#define FUNCTION_FS_NAME                        "ffs"
#define FUNCTION_FS_PATH                        "/dev/ffs"
#define FUNCTION_FS_TYPE                        "functionfs"

/* Kernel 3.14 has the additional sub-path "soc0" inside */
#define IAP2_USB_ROLE_SWITCH_OTG_GLOB_314       "/sys/devices/soc0/soc.0/21*/2184*/*"
/* Kernel 3.8 OTG path */
#define IAP2_USB_ROLE_SWITCH_OTG_GLOB           "/sys/devices/soc.0/21*/2184*/*"
#define IAP2_VBUS_POWER_BDCL                   "/sys/class/udc/*/device/vbus"

#define STR_USB_DYN_NUM                         "usb*"

#define STR_GADGET                              "gadget"
#define STR_HOST                                "host"

/* vbus is not available in case we are not for example on a imx6-qai target */
#define STR_VBUS_AUTO                           "vbus_auto"
#define STR_ENABLE                              "enable"
#define STR_DISABLE                             "disable"

/* Depreciated */
#define IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_AI          "425"
#define IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_SD          "86"

/* g_ffs load module parameter */
#define STR_ACC_INFO_NAME                       "AmazingProduct"
#define STR_ACC_INFO_MANUFACTURER               "ADIT"
#define STR_ACC_INFO_MODEL_IDENTIFIER           "15967"
#define STR_ACC_INFO_SERIAL_NUM                 "12345678"
#define STR_ACC_INFO_VENDOR_ID                  "44311"
#define STR_ACC_INFO_PRODUCT_ID                 "1111"
#define STR_ACC_INFO_BCD_DEVICE                 "1"
#define STR_ACC_INFO_QMULT                      "1"

#define UDC_DEVICE_NAME_IMX6                    "ci_hdrc.0"
#define UDC_DEVICE_NAME_BXT                     "dwc3.1.auto"
#define UDC_DEVICE_NAME_RCAR                    "e6590000.usb"

#define STR_MAX_LENGTH                          256
#define MAX_STRING_LEN                          256

typedef struct
{
    uint16_t idVendor;
    uint16_t idProduct;
    char serial[256];
    char sysPath[256];
} iap2USBDeviceInfo_t;

typedef struct
{
    struct udev* udev;
    struct udev_monitor* monitor;
    iap2USBDeviceInfo_t deviceInfo;
} iap2VendorRequestMonitor_t;

typedef struct {
    char vendorId[MAX_STRING_LEN];
    char productId[MAX_STRING_LEN];
    char manufacturer[MAX_STRING_LEN];
    char name[MAX_STRING_LEN];
    char serial[MAX_STRING_LEN];
    char bcdDevice[MAX_STRING_LEN];
    char qmult[MAX_STRING_LEN];
} iap2LoadGadgetFSModuleParameters_t;

typedef union
{
    iap2LoadGadgetFSModuleParameters_t gadget_fs;
} iap2LoadModuleParameters;


class GadgetLoader
{
public:
    GadgetLoader ();
    ~GadgetLoader();

   int32_t switchHUToGadget(); //switch Head-Unit to usb gadget
   int32_t switchHUToHost();   //switch HeadUnit to usb host

   int32_t LoadGadgetModules();
   int32_t UnloadGadgetModules();

   void setRollSwitchInfo(std::string);

   int32_t iap2FindVbus();
   int32_t iap2SwitchOTG( const char* value);
   int32_t iap2SwitchVbusPower(const char* value);
   int32_t iap2findOTGPath(char* otgPath, U32 len, const char* otgGlob);
   int32_t iap2SwitchVbusAuto(const char* otgPath, const char* value);

   uint32_t iap2CurrTimeMs(void);
   uint32_t iap2CurrTimeValToMs(struct timeval* currTime);

   bool iap2CommonWrite(const char* path, const char* subPath, const char* value, bool checkBeforeWrite);
   bool iap2CommonWriteValue(const char* path, const char* value);

   int32_t iap2InitGadgetConfiguration(iAP2_usbg_config_t* usb_gadget_configuration, uint8_t DeviceInstance);
protected:
   //some helper  functions
   bool isKernel314(void);
   int32_t LoadKernelModule(const iap2LoadModuleParameters* iap2ModuleLoadParam, const char* modname, uint32_t length);
   int32_t UnloadKernelModule(const char* modname);

private:
   iAP2USBRoleSwitchInfo roleSwitchInfo;
   udcParamInfo_t* _udcParam;
   iAP2_usbg_config_t usb_gadget_configuration;
};

} } /* namespace adit { namespace bdcl */
#endif /* BDCL_GADGETLOADER_H */
